# Synthetic Logic Network Generator

This project provides scripts to generate and combine synthetic logic networks.  

- **Small network generation (`generate_net.py`)**  
  Generates random logic networks with configurable numbers of inputs, outputs, and logic gates. Supports both AND-only (AN) and AND-OR mixed (ANO) structures. Each network is simulated to produce full truth tables, optionally with noise augmentation. Visualizations in HTML and Boolean network export are also available for analysis.

- **Large network merging (`net_combine.py`)**  
  Combines multiple small networks into larger, more complex circuits while respecting target input/output sizes and total gate count. Node selection considers priority, dangling status, and structural diversity to reduce redundancy. Outputs are reassigned to nontrivial nodes to maintain meaningful logical expressions. Multiprocessing support allows efficient batch generation of large networks.

- **Core data structures (`net.py`)**  
  Defines `AIGNode` for individual gates or inputs and `AIG` for the full network. Supports node connections, truth table computation, and structural edits such as removing dangling nodes. Provides methods to export networks to `.aag`, `.bnet`, `.truth`, and visualization formats. Key functions like `compute_truth_tables()` and `calculate_key()` enable uniqueness checking and simulation.

---

## Directory Structure

Generated files are organized as:

```aiignore
generation_scripts/
├── tools/ # Utility tools directory
├── generate_net.py # Small-Scale logic network generation script
├── methods_merge.py # Methods for network merging
├── methods_plain.py # Basic methods implementation
├── net.py # Core logic network function module
├── net_combine.py # Large-Scale logic network merging main script
└── readme.md # Project documentation
```

---
## Usage

### 1. Generate small networks
```bash
python generate_net.py --use-aig --fmt html
```

**Arguments:**

- use-aig: use AND-only gates (AIG); otherwise AND/OR mix (AOIG).

- fmt: visualization format (html default).

Example (inside generate_net.py):

combins = [(5, 5, 20), (10, 10, 80)]  # (inputs, outputs, gates)



### 2. Combine into large networks

```
python net_combine.py --use-aig --num_aigs 50 --tt_len 15 --parallel
```

Arguments:

- `--use-aig`: AIG vs AOIG mode.
- `--num_aigs`: number of large networks to generate.
- `--tt_len`: max truth table length.
- `--parallel`: enable multiprocessing.
- `--batch_size`: number of sub-AIGs per batch.
- `--multiple`: oversampling factor.

Example (inside `net_combine.py`):

```
combins = [(80, 80, 2560)]          # large nets (in, out, and)
small_aigs = [(10, 10, 7, 310)]     # small nets (in, out, count, and)
```

------

## Dependencies

- Python 3.8+
- `numpy`, `tqdm`

Install via:

```
pip install numpy tqdm
```
